<?php namespace App\Controllers\Api\Manager\PlansExtra;

use App\Controllers\PrivateController;
use App\Models\PlansExtraModel;
use CodeIgniter\HTTP\ResponseInterface;
use ReflectionException;

class RemovePlanExtra extends PrivateController
{
  	/**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Remove plan extra
     * @return ResponseInterface
     * @throws ReflectionException
     */
    public function index(): ResponseInterface
    {
        $id = (int) $this->request->getGet("id");

        $plansExtra = new PlansExtraModel();

        $planExtra = $plansExtra
          	->where("id", $id)
          	->select("id")
          	->first();

        if (!$planExtra) {
            return $this->respond(["message" => lang("Message.message_59")], 400);
        }

        $plansExtra->update($planExtra["id"], [
            "deleted_at" => time()
        ]);

        return $this->respond(["status" => "ok"], 200);
    }
}